<?php

namespace App\Services\Sms;

use App\Models\SmsLog;
use GuzzleHttp\Client;

class BeemSmsService
{
    protected Client $http;
    protected array $cfg;

    public function __construct()
    {
        $this->cfg = config('services.beem');
        $this->http = new Client([
            'base_uri' => 'https://apisms.beem.africa/v1/',
            'timeout'  => 10,
        ]);
    }

    public function send(string $to, string $message): SmsLog
    {
        $log = SmsLog::create([
            'provider' => 'beem',
            'to'       => $to,
            'sender'   => $this->cfg['sender_id'],
            'message'  => $message,
            'status'   => 'queued',
        ]);

        $auth = base64_encode($this->cfg['api_key'].':'.$this->cfg['secret_key']);

        try {
            $payload = [
                'source_addr' => $this->cfg['sender_id'],
                'encoding'    => 0,
                'schedule_time' => '',
                'message'     => $message,
                'recipients'  => [
                    ['recipient_id' => 1, 'dest_addr' => $to],
                ],
            ];

            $resp = $this->http->post('send', [
                'headers' => [
                    'Authorization' => 'Basic '.$auth,
                    'Content-Type'  => 'application/json',
                ],
                'json' => $payload,
            ]);

            $body = json_decode((string) $resp->getBody(), true);

            $log->status      = 'sent';
            $log->provider_id = $body['request_id'] ?? null;
            $log->payload     = $body;
            $log->save();
        } catch (\Throwable $e) {
            $log->status  = 'failed';
            $log->payload = ['error' => $e->getMessage()];
            $log->save();
        }

        return $log;
    }
}
