<?php

namespace App\Services\Sms;

use Illuminate\Support\Facades\Http;

class BeemSms
{
    public static function send(string $phone, string $message): bool
    {
        $apiKey    = config('beem.api_key');
        $secretKey = config('beem.secret_key');
        $senderId  = config('beem.sender_id', 'BlueBando');

        if (!$apiKey || !$secretKey) {
            // silently fail in dev
            return false;
        }

        $payload = [
            'source_addr'   => $senderId,
            'encoding'      => 0,
            'schedule_time' => '',
            'message'       => $message,
            'recipients'    => [
                ['recipient_id' => 1, 'dest_addr' => $phone],
            ],
        ];

        $res = Http::withBasicAuth($apiKey, $secretKey)
            ->acceptJson()
            ->post('https://apisms.beem.africa/v1/send', $payload);

        return $res->successful();
    }
}
