<?php

namespace App\Services\Router;

use App\Models\Voucher;
use App\Services\Router\MikroTikLive;
use RouterOS\Query;

class MikroTikProvisioner
{
    /**
     * Create hotspot user for a voucher.
     */
    public static function createHotspotUser(Voucher $voucher): array
    {
        $router = $voucher->router;
        $plan   = $voucher->plan;

        $client = MikroTikLive::client($router);

        $q = (new Query('/ip/hotspot/user/add'))
            ->equal('name', $voucher->code)
            ->equal('password', $voucher->password);

        if ($plan?->profile) {
            $q->equal('profile', $plan->profile);
        }

        return $client->query($q)->read();
    }

    /**
     * Remove hotspot user when voucher cancelled.
     */
    public static function removeHotspotUser(Voucher $voucher): void
    {
        $router = $voucher->router;
        $client = MikroTikLive::client($router);

        // find and remove by name
        $users = $client->query(
            (new Query('/ip/hotspot/user/print'))->where('name', $voucher->code)
        )->read();

        if (!empty($users[0]['.id'])) {
            $client->query(
                (new Query('/ip/hotspot/user/remove'))->equal('.id', $users[0]['.id'])
            )->read();
        }
    }
}
