<?php
namespace App\Services\Payments;

use App\Models\Order;

class PesapalAdapter implements PaymentGateway
{
    public function createCheckout(array $p): PaymentIntent
    {
        // TODO: Implement provider call
        return new PaymentIntent(null, null, $p['reference'] ?? null);
    }
    public function verify(string $reference): PaymentStatus { return new PaymentStatus('unknown'); }
    public function handleWebhook(array $request): void {
        $ref = $request['reference'] ?? null;
        if (!$ref) return;
        if ($order = Order::where('reference',$ref)->first()) {
            $order->update(['status'=>'paid','meta_json'=>$request]);
        }
    }
}
