<?php
namespace App\Services\Payments;

use InvalidArgumentException;

class GatewayFactory {
    public function for(string $provider): PaymentGateway {
        return match($provider) {
            'azam_pay'    => app(AzamPayAdapter::class),
            'flutterwave' => app(FlutterwaveAdapter::class),
            'zenopay_tz'  => app(ZenoPayAdapter::class),
            'selcom'      => app(SelcomAdapter::class),
            'clickpesa'   => app(ClickPesaAdapter::class),
            'pesapal'     => app(PesapalAdapter::class),
            default => throw new InvalidArgumentException('Unknown provider: '.$provider)
        };
    }
}

interface PaymentGateway {
    public function createCheckout(array $payload): PaymentIntent;
    public function verify(string $reference): PaymentStatus;
    public function handleWebhook(array $request): void;
}

class PaymentIntent {
    public function __construct(public ?string $id=null, public ?string $url=null, public ?string $reference=null) {}
}
class PaymentStatus {
    public function __construct(public string $status, public ?array $meta=null) {}
}
