<?php
namespace App\Services\Payments;

class AzamPaySignature
{
    public static function verify(?string $provided, string $rawBody, ?string $secret = null): bool
    {
        $secret = $secret ?? env('PAYMENT_AZAM_WEBHOOK_SECRET');
        if (!$secret) { return true; }
        if (!$provided) { return false; }
        $computed = base64_encode(hash_hmac('sha256', $rawBody, $secret, true));
        $computedHex = hash_hmac('sha256', $rawBody, $secret);
        $provided = trim($provided);
        return hash_equals($computed, $provided) || hash_equals($computedHex, $provided);
    }
}
