<?php

namespace App\Http\Middleware;

use App\Models\Freelancer;
use Closure;
use Illuminate\Http\Request;

class EnsureFreelancer
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        if (!$user) {
            abort(403, 'Not authenticated');
        }

        $freelancer = Freelancer::where('user_id', $user->id)->first();

        if (!$freelancer) {
            abort(403, 'Freelancer profile not found');
        }

        // Share to controllers / views
        $request->attributes->set('freelancer', $freelancer);
        view()->share('currentFreelancer', $freelancer);

        return $next($request);
    }
}
