<?php

namespace App\Http\Controllers;

use App\Models\Order;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $status = $request->input('status');
        $gateway = $request->input('gateway');

        $q = Order::with(['router', 'plan'])->orderByDesc('id');

        if ($status) {
            $q->where('status', $status);
        }
        if ($gateway) {
            $q->where('gateway', $gateway);
        }

        $orders = $q->paginate(25);

        return view('payments.orders.index', compact('orders', 'status', 'gateway'));
    }

    public function show(Order $order)
    {
        $order->load(['router', 'plan', 'user']);
        return view('payments.orders.show', compact('order'));
    }
}
