<?php $__env->startSection('title','Routers — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <div style="display:flex;gap:10px;justify-content:space-between;align-items:center;margin-bottom:12px">
    <div>
      <h1 style="margin:0 0 6px;font-size:22px">Routers</h1>
      <div class="muted">Manage hotspot routers, poll status and metrics.</div>
    </div>
    <div style="display:flex;gap:8px">
      <form method="get" action="<?php echo e(route('routers.index')); ?>" class="top-search" style="position:relative;min-width:220px">
        <input name="s" value="<?php echo e(request('s')); ?>" placeholder="Search host or name"
               style="width:100%; padding:10px 12px; border-radius:12px; background:var(--bb-elev); color:var(--bb-text); border:1px solid var(--bb-border); outline:none">
      </form>
      <a href="<?php echo e(route('routers.create')); ?>" class="btn" style="text-decoration:none">+ Add Router</a>
    </div>
  </div>

  <div class="card full">
    <table>
      <thead>
        <tr>
          <th>Name</th>
          <th>Host</th>
          <th>Status</th>
          <th>CPU</th>
          <th>RAM</th>
          <th>Uptime</th>
          <th>VPN</th>
          <th>Updated</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <?php
            // STATUS
            $status = $r->last_status ?: $r->status ?: 'unknown';
            $statusClass = match ($status) {
                'online'  => 'paid',
                'offline' => 'failed',
                'warning' => 'pending',
                default   => 'pending',
            };

            // CPU – prefer last_cpu, fallback to cpu_load
            $cpuText = $r->last_cpu
                ?? ($r->cpu_load !== null ? $r->cpu_load.'%' : null);

            // RAM – from total/free memory
            $memPercent = null;
            if ($r->total_memory && $r->free_memory !== null) {
                $memPercent = round(($r->total_memory - $r->free_memory) / $r->total_memory * 100);
            }

            // Uptime – prefer last_uptime, fallback to uptime_seconds
            if ($r->last_uptime) {
                $uptimeText = $r->last_uptime;
            } elseif ($r->uptime_seconds) {
                $uptimeText = gmdate('j\d H\h i\m s\s', $r->uptime_seconds);
            } else {
                $uptimeText = null;
            }

            // Updated – prefer last_checked_at, then last_seen, then updated_at
            $updatedTs = $r->last_checked_at ?? $r->last_seen ?? $r->updated_at;
          ?>

          <tr>
            
            <td>
              <strong><?php echo e($r->name); ?></strong><br>
              <span class="muted" style="font-size:12px">
                <?php echo e($r->last_model ?? $r->model ?? $r->board_name ?? '—'); ?>

              </span>
            </td>

            
            <td><?php echo e($r->host); ?></td>

            
            <td>
              <span class="status <?php echo e($statusClass); ?>">
                <?php echo e(strtoupper($status)); ?>

              </span>
              <?php if($r->last_latency_ms !== null): ?>
                <div class="muted" style="font-size:12px;margin-top:2px">
                  <?php echo e($r->last_latency_ms); ?> ms
                </div>
              <?php endif; ?>
            </td>

            
            <td><?php echo e($cpuText ?? '—'); ?></td>

            
            <td>
              <?php echo e($memPercent !== null ? $memPercent.'% used' : '—'); ?>

            </td>

            
            <td>
              <?php echo e($uptimeText ?? '—'); ?>

            </td>

            
            <td>
              <?php
                $vpn = \App\Models\VpnClient::where('router_id', $r->id)->latest()->first();
              ?>

              <?php if($vpn && $vpn->status === 'active'): ?>
                <span class="status paid">ON</span>
                <div class="muted" style="font-size:12px"><?php echo e($r->vpn_ip ?? '—'); ?></div>
                <div style="margin-top:6px">
                  <a class="btn-ghost" href="<?php echo e(route('vpn.show', $vpn)); ?>">View</a>
                </div>
              <?php else: ?>
                <a class="btn-ghost" href="<?php echo e(route('vpn.create', $r)); ?>">Create</a>
              <?php endif; ?>
            </td>

            
            <td class="muted">
              <?php if($updatedTs): ?>
                <?php echo e($updatedTs->diffForHumans()); ?>

              <?php else: ?>
                —
              <?php endif; ?>
            </td>

            
            <td style="text-align:right">
              <a class="btn-ghost" href="<?php echo e(route('routers.show',$r)); ?>">Open</a>
              <a class="btn-ghost" href="<?php echo e(route('routers.edit',$r)); ?>">Edit</a>
              <form method="POST" action="<?php echo e(route('routers.destroy',$r)); ?>" style="display:inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button class="btn-ghost" onclick="return confirm('Delete router?')">Delete</button>
              </form>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr><td colspan="9" class="muted">No routers yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div style="margin-top:10px"><?php echo e($routers->withQueryString()->links()); ?></div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/blue/resources/views/routers/index.blade.php ENDPATH**/ ?>