<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_','-',app()->getLocale())); ?>">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>BlueBando v3 — Sign in</title>

  <!-- Self-contained styles (no Tailwind/CDN needed) -->
  <style>
    :root{
      --bb-bg:#0d1117; --bb-panel:#0f172a; --bb-panel-2:#0b1220;
      --bb-blue:#0ea5e9; --bb-blue-2:#3b82f6; --bb-cyan:#22d3ee;
      --bb-text:#e5e7eb; --bb-dim:#9ca3af; --bb-danger:#ef4444; --bb-ok:#10b981;
      --r:18px; --sh:0 22px 60px rgba(0,0,0,.45);
    }
    *{box-sizing:border-box} html,body{height:100%}
    body{
      margin:0; color:var(--bb-text);
      background:
        url('<?php echo e(asset('images/bg-login.jpg')); ?>') center/cover no-repeat,
        radial-gradient(1200px 700px at 80% -10%, #0b3a6b44, transparent 60%),
        radial-gradient(1200px 700px at -10% 110%, #064e3b33, transparent 60%),
        linear-gradient(180deg, #0b1020, var(--bb-bg));
      font: 14px/1.45 ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial;
      display:grid; place-items:center; padding:24px;
    }
    .wrap{width:min(100%, 1020px); display:grid; grid-template-columns: 1.1fr .9fr; gap:28px}
    @media (max-width:960px){ .wrap{grid-template-columns:1fr} }

    /* Brand panel */
    .brand{
      position:relative; overflow:hidden;
      background: linear-gradient(160deg, rgba(59,130,246,.16), rgba(14,165,233,.10));
      border:1px solid rgba(148,163,184,.12);
      border-radius:var(--r); box-shadow:var(--sh); padding:28px;
    }
    .brand::after{
      content:""; position:absolute; inset:-2px; pointer-events:none;
      background:
        radial-gradient(700px 280px at 10% -30%, rgba(14,165,233,.18), transparent 40%),
        radial-gradient(700px 280px at 120% 120%, rgba(59,130,246,.16), transparent 40%);
      filter: blur(8px);
    }
    .brand-head{display:flex; gap:14px; align-items:center}
    .logo{
      width:72px;height:72px;border-radius:16px;
      background:linear-gradient(135deg,var(--bb-blue-2),var(--bb-blue));
      display:grid;place-items:center;box-shadow:0 14px 40px rgba(59,130,246,.35)
    }
    .logo img{width:48px;height:48px;display:block}
    .brand h1{margin:6px 0 4px; font-size:30px; letter-spacing:.2px}
    .brand p{margin:0;color:var(--bb-dim)}
    .badges{display:flex; flex-wrap:wrap; gap:8px; margin-top:14px}
    .badge{font-size:11px; padding:5px 10px; border-radius:999px; border:1px solid rgba(148,163,184,.18); background:#0ea5e91a; color:#86e2ff}

    .features{margin-top:18px; display:grid; gap:10px}
    .f{display:flex; gap:10px; align-items:flex-start}
    .dot{width:10px;height:10px;border-radius:999px;background:linear-gradient(135deg,#22d3ee,#3b82f6); box-shadow:0 0 0 4px #22d3ee33; margin-top:6px}

    /* Login card */
    .card{
      background:
        linear-gradient(180deg, rgba(255,255,255,.02), transparent),
        radial-gradient(900px 320px at -20% -10%, rgba(14,165,233,.10), transparent 40%),
        var(--bb-panel);
      border:1px solid rgba(148,163,184,.12);
      border-radius:var(--r); box-shadow:var(--sh); padding:26px; position:relative;
    }
    .card .title{display:flex; gap:12px; align-items:center; margin-bottom:12px}
    .muted{color:var(--bb-dim); font-size:12px}

    label{display:block;font-size:12px;color:var(--bb-dim);margin:14px 2px 6px}
    .input{
      width:100%; padding:14px; border-radius:14px;
      background: linear-gradient(180deg, #0d1525, #0b1220);
      color:var(--bb-text); border:1px solid rgba(148,163,184,.18);
      outline:none; transition:.22s border, .22s box-shadow;
    }
    .input:focus{border-color:#38bdf8; box-shadow: 0 0 0 4px #38bdf822}
    .pw-wrap{position:relative}
    .pw-toggle{
      position:absolute; right:10px; top:50%; transform:translateY(-50%);
      font-size:12px; color:#93c5fd; cursor:pointer; user-select:none
    }

    .actions{display:flex; align-items:center; justify-content:space-between; margin-top:12px}
    .check{display:flex; gap:8px; align-items:center; font-size:12px; color:var(--bb-dim)}
    .link{color:#93c5fd; text-decoration:none} .link:hover{text-decoration:underline}

    .btn{
      width:100%; padding:14px; border-radius:14px; border:0; cursor:pointer; color:white;
      background:linear-gradient(135deg, var(--bb-blue-2), var(--bb-blue));
      box-shadow: 0 12px 36px #0ea5e955, inset 0 0 0 1px rgba(255,255,255,.12);
      font-weight:700; letter-spacing:.3px; transition:transform .08s ease, filter .2s;
    }
    .btn:hover{filter:brightness(1.06)} .btn:active{transform:translateY(1px)}

    .alert{padding:10px 12px;border-radius:12px;margin-top:10px;font-size:13px}
    .error{background:#ef44441a;border:1px solid #ef44444d;color:#fecaca}
    .ok{background:#10b9811a;border:1px solid #10b98166;color:#d1fae5}

    .foot{margin-top:16px; font-size:12px; color:var(--bb-dim); text-align:center}
    .lang{display:flex; gap:8px; justify-content:center; margin-top:10px}
    .lang a{font-size:12px; color:#a5b4fc; text-decoration:none; padding:6px 10px; border-radius:999px; border:1px solid rgba(148,163,184,.16)}
    .lang a:hover{background:#111827}

    /* Small watermark (optional) */
    .wm{
      position:absolute; inset:auto -10px -10px auto; opacity:.08; pointer-events:none;
      font-weight:900; font-size:84px; letter-spacing:2px; color:#60a5fa
    }
  </style>
</head>
<body>

  <div class="wrap">

    <!-- Brand / left -->
    <section class="brand">
      <div class="brand-head">
        <div class="logo">
          <?php $logo = asset('images/bluebando-logo.svg'); ?>
          <img src="<?php echo e($logo); ?>" alt="BlueBando" onerror="this.outerHTML='<span style=&quot;font-weight:800;color:white&quot;>BB</span>'">
        </div>
        <div>
          <h1>BlueBando v3</h1>
          <p>Smart Wi-Fi Hotspot • Vouchers • Payments • SMS</p>
          <div class="badges">
            <span class="badge">Multi-Router</span>
            <span class="badge">AzamPay • Selcom • Pesapal • Flutterwave • ClickPesa • ZenoPay</span>
            <span class="badge">Freelancers</span>
            <span class="badge">Beem • Twilio • NextSMS</span>
            <span class="badge">English • Swahili</span>
          </div>
        </div>
      </div>

      <div class="features">
        <div class="f"><span class="dot"></span><div>Manage many MikroTik hotspots from a single, fast dashboard.</div></div>
        <div class="f"><span class="dot"></span><div>Create & print vouchers, auto-commission for freelancers.</div></div>
        <div class="f"><span class="dot"></span><div>Clean reports: sales, usage, top plans, per-router KPIs.</div></div>
      </div>
    </section>

    <!-- Login card / right -->
    <section class="card">
      <div class="wm">BLUEBANDO</div>

      <div class="title">
        <div style="width:12px;height:12px;border-radius:999px;background:linear-gradient(135deg,#22d3ee,#3b82f6); box-shadow:0 0 0 6px #22d3ee22"></div>
        <div>
          <div style="font-weight:800; letter-spacing:.3px; font-size:18px">Welcome back</div>
          <div class="muted">Sign in to your BlueBando account</div>
        </div>
      </div>

      <?php if(session('status')): ?>
        <div class="alert ok"><?php echo e(session('status')); ?></div>
      <?php endif; ?>
      <?php if($errors->any()): ?>
        <div class="alert error"><?php echo e($errors->first()); ?></div>
      <?php endif; ?>

      <form method="POST" action="<?php echo e(route('login')); ?>" novalidate>
        <?php echo csrf_field(); ?>

        <label for="email">Email</label>
        <input id="email" name="email" type="email" class="input" placeholder="owner@blue.local" required autofocus>

        <label for="password">Password</label>
        <div class="pw-wrap">
          <input id="password" name="password" type="password" class="input" placeholder="••••••••" required>
          <span class="pw-toggle" onclick="togglePw()">Show</span>
        </div>

        <div class="actions">
          <label class="check">
            <input type="checkbox" name="remember"> Remember me
          </label>
          <?php if(Route::has('password.request')): ?>
            <a class="link" href="<?php echo e(route('password.request')); ?>">Forgot password?</a>
          <?php endif; ?>
        </div>

        <div style="margin-top:16px"><button class="btn" type="submit">Sign in</button></div>
      </form>

      <div class="lang">
        <a href="<?php echo e(url('lang/en')); ?>">English</a>
        <a href="<?php echo e(url('lang/sw')); ?>">Swahili</a>
      </div>

      <div class="foot">
        © <?php echo e(date('Y')); ?> BlueBando WiFi — TekiSoft
      </div>
    </section>

  </div>

  <!-- Tiny UX helpers -->
  <script>
    function togglePw(){
      const el = document.getElementById('password');
      const t  = document.querySelector('.pw-toggle');
      if(el.type === 'password'){ el.type='text'; t.textContent='Hide'; }
      else { el.type='password'; t.textContent='Show'; }
    }
  </script>
</body>
</html><?php /**PATH /var/www/blue/resources/views/auth/login.blade.php ENDPATH**/ ?>