
<?php $__env->startSection('title','Plans — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  
  <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:14px;gap:12px;flex-wrap:wrap">
    <div>
      <h1 style="margin:0 0 4px">Plans</h1>
      <div class="muted">Manage hotspot plans / profiles per router. Changes are synced to MikroTik.</div>
    </div>

    <div style="display:flex;gap:8px;align-items:center;flex-wrap:wrap">
      <form method="get" action="<?php echo e(route('plans.index')); ?>">
        <select class="input" name="router_id" onchange="this.form.submit()">
          <option value="">All routers</option>
          <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($r->id); ?>" <?php if(($routerId ?? null) == $r->id): echo 'selected'; endif; ?>><?php echo e($r->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </form>

      <a href="<?php echo e(route('plans.create')); ?>" class="btn" style="text-decoration:none;white-space:nowrap">
        + New Plan
      </a>
    </div>
  </div>

  
  <?php if(session('status')): ?>
    <div class="card full" style="margin-bottom:12px;border-left:3px solid var(--bb-green)">
      <div style="display:flex;align-items:center;gap:8px">
        <span style="font-size:18px">✅</span>
        <div><?php echo e(session('status')); ?></div>
      </div>
    </div>
  <?php endif; ?>

  
  <div class="card full">
    <?php if($plans->count()): ?>
      <table>
        <thead>
          <tr>
            <th style="width:180px">Name / Profile</th>
            <th>Router</th>
            <th>Price</th>
            <th>Validity</th>
            <th>Rate Limit</th>
            <th>DL / UL Limit (MB)</th>
            <th>Status</th>
            <th style="width:120px">Updated</th>
            <th style="width:140px;text-align:right">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td>
                <div style="font-weight:600"><?php echo e($plan->name); ?></div>
                <div class="muted" style="font-size:12px">
                  Profile: <?php echo e($plan->profile ?: $plan->name); ?>

                </div>
              </td>

              <td>
                <?php if($plan->router): ?>
                  <div><?php echo e($plan->router->name); ?></div>
                  <div class="muted" style="font-size:12px"><?php echo e($plan->router->host); ?></div>
                <?php else: ?>
                  <span class="muted" style="font-size:12px">Any router</span>
                <?php endif; ?>
              </td>

              <td>
                <?php echo e(number_format($plan->price)); ?>

                <span class="muted"><?php echo e($plan->currency ?: config('bluebando.currency','TZS')); ?></span>
              </td>

              <td><?php echo e($plan->validity_hours); ?>h</td>

              <td><?php echo e($plan->rate_limit ?: '—'); ?></td>

              <td>
                <?php
                  $dl = $plan->download_limit_mb;
                  $ul = $plan->upload_limit_mb;
                ?>
                <?php if($dl || $ul): ?>
                  <?php echo e($dl ?: 0); ?>/<?php echo e($ul ?: 0); ?>

                <?php else: ?>
                  <span class="muted">Unlimited</span>
                <?php endif; ?>
              </td>

              <td>
                <?php if($plan->is_active): ?>
                  <span class="status paid">Active</span>
                <?php else: ?>
                  <span class="status pending">Disabled</span>
                <?php endif; ?>
              </td>

              <td class="muted">
                <?php echo e(optional($plan->updated_at)->diffForHumans() ?? '—'); ?>

              </td>

              <td style="text-align:right">
                <div style="display:flex;justify-content:flex-end;gap:6px">
                  <a href="<?php echo e(route('plans.edit',$plan)); ?>"
                     class="btn-ghost"
                     style="padding:6px 10px;font-size:12px;text-decoration:none">
                    Edit
                  </a>

                  <form method="POST" action="<?php echo e(route('plans.destroy',$plan)); ?>"
                        onsubmit="return confirm('Delete this plan and its router profile?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit"
                            class="btn-ghost"
                            style="padding:6px 10px;font-size:12px;border-color:rgba(239,68,68,.4);color:var(--bb-red)">
                      Delete
                    </button>
                  </form>
                </div>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>

      
      <div style="margin-top:12px">
        <?php echo e($plans->withQueryString()->links()); ?>

      </div>
    <?php else: ?>
      <div class="muted">
        No plans found yet. Click <strong>“+ New Plan”</strong> to create your first hotspot plan
        and it will be synced to MikroTik automatically.
      </div>
    <?php endif; ?>
  </div>

  
  <?php if(!empty($liveRouter)): ?>
    <div style="margin-top:18px">
      <h2 style="margin:0 0 6px;font-size:18px">
        Live profiles on router:
        <span style="font-weight:600"><?php echo e($liveRouter->name); ?></span>
        <span class="muted" style="font-size:12px">(<?php echo e($liveRouter->host); ?>)</span>
      </h2>
      <div class="muted" style="font-size:12px;margin-bottom:8px">
        Data fetched in real-time from <code>/ip hotspot user profile</code>.
      </div>

      <div class="card full">
        <?php if(!empty($liveProfiles)): ?>
          <table>
            <thead>
              <tr>
                <th>Name</th>
                <th>Rate limit</th>
                <th>Shared users</th>
                <th>Idle timeout</th>
                <th>Keepalive</th>
                <th>Parent queue</th>
                <th>Comment</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $liveProfiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($p['name']); ?></td>
                  <td><?php echo e($p['rate_limit'] ?? '—'); ?></td>
                  <td><?php echo e($p['shared_users'] ?? '—'); ?></td>
                  <td><?php echo e($p['idle_timeout'] ?? '—'); ?></td>
                  <td><?php echo e($p['keepalive_timeout'] ?? '—'); ?></td>
                  <td><?php echo e($p['parent_queue'] ?? '—'); ?></td>
                  <td class="muted"><?php echo e($p['comment'] ?? '—'); ?></td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        <?php else: ?>
          <div class="muted">
            No hotspot user profiles found on this router
            (or failed to read API). Check MikroTik API connectivity & permissions.
          </div>
        <?php endif; ?>
      </div>
    </div>
  <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/blue/resources/views/plans/index.blade.php ENDPATH**/ ?>