
<?php $__env->startSection('title','Active Hotspot Users — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <?php
    // formatter
    function bb_format_bytes($bytes) {
        $bytes = (float)$bytes;
        if ($bytes < 1024) return $bytes.' B';
        if ($bytes < 1048576) return round($bytes/1024,2).' KB';
        if ($bytes < 1073741824) return round($bytes/1048576,2).' MB';
        if ($bytes < 1099511627776) return round($bytes/1073741824,2).' GB';
        return round($bytes/1099511627776,2).' TB';
    }

    $count = is_array($sessions) ? count($sessions) : 0;

    // compute max traffic for bar + chart
    $maxTraffic = 0;
    foreach ($sessions as $tmp) {
        $t = (int)($tmp['_traffic'] ?? 0);
        if ($t > $maxTraffic) $maxTraffic = $t;
    }
    $maxTraffic = $maxTraffic ?: 1;

    $routerId = optional($currentRouter)->id;
  ?>

  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:center;gap:12px">
    <div>
      <h1 style="margin:0 0 4px;font-size:22px;letter-spacing:.2px;display:flex;align-items:center;gap:8px">
        <?php if (isset($component)) { $__componentOriginala231aa52073ee357093dd0e300d7d061 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala231aa52073ee357093dd0e300d7d061 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.ico','data' => ['name' => 'wifi','size' => 22]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('ico'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'wifi','size' => 22]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala231aa52073ee357093dd0e300d7d061)): ?>
<?php $attributes = $__attributesOriginala231aa52073ee357093dd0e300d7d061; ?>
<?php unset($__attributesOriginala231aa52073ee357093dd0e300d7d061); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala231aa52073ee357093dd0e300d7d061)): ?>
<?php $component = $__componentOriginala231aa52073ee357093dd0e300d7d061; ?>
<?php unset($__componentOriginala231aa52073ee357093dd0e300d7d061); ?>
<?php endif; ?>
        <span>Hotspot Active</span>
      </h1>
      <div class="muted" style="font-size:13px">
        Live hotspot sessions for <strong><?php echo e($currentRouter?->name ?? '—'); ?></strong>
      </div>
    </div>

    <form method="GET" action="<?php echo e(route('hotspot.active.index')); ?>"
          style="display:flex;gap:8px;align-items:center;flex-wrap:wrap;justify-content:flex-end">

      <select name="router_id" class="input" style="min-width:180px">
        <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($r->id); ?>" <?php if($routerId === $r->id): echo 'selected'; endif; ?>>
            <?php echo e($r->name); ?>

          </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>

      <select name="limit" class="input" style="width:110px">
        <?php $__currentLoopData = [50,100,200,500]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($opt); ?>" <?php if($limit == $opt): echo 'selected'; endif; ?>>Last <?php echo e($opt); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>

      <select name="sort" class="input" style="width:130px">
        <option value="traffic"   <?php if($sort === 'traffic'): echo 'selected'; endif; ?>>Traffic</option>
        <option value="bytes_in"  <?php if($sort === 'bytes_in'): echo 'selected'; endif; ?>>Bytes In</option>
        <option value="bytes_out" <?php if($sort === 'bytes_out'): echo 'selected'; endif; ?>>Bytes Out</option>
        <option value="uptime"    <?php if($sort === 'uptime'): echo 'selected'; endif; ?>>Uptime</option>
        <option value="user"      <?php if($sort === 'user'): echo 'selected'; endif; ?>>User</option>
      </select>

      <select name="dir" class="input" style="width:90px">
        <option value="desc" <?php if($dir === 'desc'): echo 'selected'; endif; ?>>Desc</option>
        <option value="asc"  <?php if($dir === 'asc'): echo 'selected'; endif; ?>>Asc</option>
      </select>

      <button class="btn-ghost" type="submit">Apply</button>

      <a href="<?php echo e(route('hotspot.active.export', ['router_id' => $routerId, 'limit' => $limit, 'sort' => $sort, 'dir' => $dir])); ?>"
         class="btn-ghost" style="text-decoration:none">
        Export CSV
      </a>
    </form>
  </div>

  <div class="card full" id="bb-active-wrapper">

    <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px;gap:10px">
      <div style="display:flex;align-items:center;gap:8px">
        <div style="width:26px;height:26px;border-radius:999px;display:grid;place-items:center;
                    background:var(--bb-elev);border:1px solid var(--bb-border);">
          <?php if (isset($component)) { $__componentOriginala231aa52073ee357093dd0e300d7d061 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala231aa52073ee357093dd0e300d7d061 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.ico','data' => ['name' => 'wifi','size' => 16]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('ico'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'wifi','size' => 16]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala231aa52073ee357093dd0e300d7d061)): ?>
<?php $attributes = $__attributesOriginala231aa52073ee357093dd0e300d7d061; ?>
<?php unset($__attributesOriginala231aa52073ee357093dd0e300d7d061); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala231aa52073ee357093dd0e300d7d061)): ?>
<?php $component = $__componentOriginala231aa52073ee357093dd0e300d7d061; ?>
<?php unset($__componentOriginala231aa52073ee357093dd0e300d7d061); ?>
<?php endif; ?>
        </div>
        <div>
          <div style="font-weight:600">
            Hotspot Active
            <span style="font-size:12px;font-weight:400" class="muted">
              • <?php echo e($count); ?> active <?php echo e(\Illuminate\Support\Str::plural('session',$count)); ?>

              • sorted by <?php echo e(strtoupper($sort)); ?>

            </span>
          </div>
          <div class="muted" style="font-size:11px">
            Auto refresh every <b>30 seconds</b>.
          </div>
        </div>
      </div>

      <div style="display:flex;align-items:center;gap:10px;font-size:12px">
        <form method="POST"
              action="<?php echo e(route('hotspot.active.kickAll', $currentRouter)); ?>"
              onsubmit="return confirm('Disconnect ALL active users on this router?')">
          <?php echo csrf_field(); ?>
          <button type="submit"
                  style="border:0;padding:6px 10px;border-radius:999px;font-size:11px;
                         background:color-mix(in srgb,var(--bb-red) 12%,transparent);
                         border:1px solid color-mix(in srgb,var(--bb-red) 45%,transparent);
                         color:color-mix(in srgb,var(--bb-red) 90%,white);cursor:pointer;">
            Kick All
          </button>
        </form>

        <div class="muted">
          Last refresh: <span style="color:var(--bb-text)"><?php echo e(now()->format('Y-m-d H:i:s')); ?></span>
        </div>
      </div>
    </div>

    
    <?php if($count > 0): ?>
      <?php
        $topTalkers = collect($sessions)
          ->sortByDesc('_traffic')
          ->take(8)
          ->map(function($s){
            return [
              'user' => $s['user'] ?? $s['name'] ?? '-',
              'traffic' => (int)($s['_traffic'] ?? 0),
            ];
          })->values()->all();

        $chartMax = 0;
        foreach ($topTalkers as $tt) {
          if ($tt['traffic'] > $chartMax) $chartMax = $tt['traffic'];
        }
        $chartMax = $chartMax ?: 1;
      ?>

      <div style="margin-bottom:12px">
        <div class="muted" style="font-size:11px;margin-bottom:4px">Top talkers (Bytes In + Out)</div>
        <div style="display:flex;gap:8px;align-items:flex-end;min-height:80px">
          <?php $__currentLoopData = $topTalkers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
              $h = max(8, ($tt['traffic'] / $chartMax) * 70);
            ?>
            <div style="flex:1;display:flex;flex-direction:column;align-items:center;gap:4px">
              <div style="width:100%;border-radius:999px 999px 4px 4px;
                          background:linear-gradient(180deg,var(--bb-primary-2),var(--bb-primary-1));
                          height:<?php echo e($h); ?>px"></div>
              <div style="font-size:10px;text-align:center;max-width:80px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap">
                <?php echo e($tt['user']); ?>

              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    <?php endif; ?>

    <?php if($count > 0): ?>
      <div style="overflow-x:auto">
        <table>
          <thead>
          <tr>
            <th>Server</th>
            <th>User</th>
            <th>Address</th>
            <th>MAC Address</th>
            <th>Uptime</th>
            <th>Bytes In</th>
            <th>Bytes Out</th>
            <th>Traffic</th>
            <th>Time Left</th>
            <th>Login By</th>
            <th style="min-width:150px">Actions</th>
            <th>Comment</th>
          </tr>
          </thead>
          <tbody>
          <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
              $server    = $s['server'] ?? $s['server-name'] ?? 'hotspot1';
              $user      = $s['user'] ?? $s['name'] ?? '';
              $address   = $s['address'] ?? '';
               $mac       = $s['mac-address']    ?? $s['mac'] ?? '';
              $uptime    = $s['uptime'] ?? '-';
              $bytesIn   = (int)($s['_bytes_in'] ?? 0);
              $bytesOut  = (int)($s['_bytes_out'] ?? 0);
              $trafficBytes = (int)($s['_traffic'] ?? 0);
              $trafficPct   = min(100, ($trafficBytes / $maxTraffic) * 100);
              $timeLeft  = $s['session-time-left'] ?? $s['time_left'] ?? '-';
              $loginBy   = $s['login-by'] ?? '';
              $comment   = $s['comment'] ?? '';
              $id        = $s['.id'] ?? $s['id'] ?? null;
            ?>

            <tr>
              <td><?php echo e($server); ?></td>
              <td style="font-weight:500"><?php echo e($user); ?></td>
              <td><?php echo e($address); ?></td>
              <td class="muted"><?php echo e($mac); ?></td>
              <td><?php echo e($uptime); ?></td>

              <td><?php echo e(bb_format_bytes($bytesIn)); ?></td>
              <td><?php echo e(bb_format_bytes($bytesOut)); ?></td>

              <td>
                <div style="font-size:11px;margin-bottom:2px">
                  <?php echo e(bb_format_bytes($trafficBytes)); ?>

                </div>
                <div style="height:6px;border-radius:999px;background:var(--bb-elev);overflow:hidden;
                            border:1px solid var(--bb-border);">
                  <div style="height:100%;width:<?php echo e($trafficPct); ?>%;
                              background:linear-gradient(90deg,var(--bb-primary-1),var(--bb-primary-2));">
                  </div>
                </div>
              </td>

              <td><?php echo e($timeLeft); ?></td>

              <td>
                <?php if($loginBy): ?>
                  <span style="padding:4px 8px;border-radius:999px;font-size:11px;
                               border:1px solid var(--bb-border);background:var(--bb-elev);">
                    <?php echo e($loginBy); ?>

                  </span>
                <?php endif; ?>
              </td>

              <td>
                <div style="display:flex;gap:6px;flex-wrap:wrap">
                  
                  <?php if($id): ?>
                    <form method="POST"
                          action="<?php echo e(route('hotspot.active.kick', $currentRouter)); ?>"
                          onsubmit="return confirm('Disconnect this session?')">
                      <?php echo csrf_field(); ?>
                      <input type="hidden" name="id" value="<?php echo e($id); ?>">
                      <button type="submit"
                              style="border:0;padding:4px 8px;border-radius:999px;font-size:11px;
                                     background:color-mix(in srgb,var(--bb-yellow) 12%,transparent);
                                     border:1px solid color-mix(in srgb,var(--bb-yellow) 45%,transparent);
                                     color:color-mix(in srgb,var(--bb-yellow) 90%,white);cursor:pointer;">
                        Kick
                      </button>
                    </form>
                  <?php endif; ?>

                  
                  <?php if($mac): ?>
                    <form method="POST"
                          action="<?php echo e(route('hotspot.active.kickByMac', $currentRouter)); ?>"
                          onsubmit="return confirm('Disconnect ALL sessions using MAC <?php echo e($mac); ?>?')">
                      <?php echo csrf_field(); ?>
                      <input type="hidden" name="mac" value="<?php echo e($mac); ?>">
                      <button type="submit"
                              style="border:0;padding:4px 8px;border-radius:999px;font-size:11px;
                                     background:var(--bb-elev);
                                     border:1px solid var(--bb-border);
                                     color:var(--bb-text);cursor:pointer;">
                        Kick MAC
                      </button>
                    </form>
                  <?php endif; ?>

                  
                  <?php if($user): ?>
                    <form method="POST"
                          action="<?php echo e(route('hotspot.active.disable', $currentRouter)); ?>"
                          onsubmit="return confirm('Disable hotspot user <?php echo e($user); ?>?')">
                      <?php echo csrf_field(); ?>
                      <input type="hidden" name="user" value="<?php echo e($user); ?>">
                      <button type="submit"
                              style="border:0;padding:4px 8px;border-radius:999px;font-size:11px;
                                     background:color-mix(in srgb,var(--bb-red) 12%,transparent);
                                     border:1px solid color-mix(in srgb,var(--bb-red) 45%,transparent);
                                     color:color-mix(in srgb,var(--bb-red) 90%,white);cursor:pointer;">
                        Disable
                      </button>
                    </form>
                  <?php endif; ?>
                </div>
              </td>

              <td class="muted" style="font-size:12px"><?php echo e($comment); ?></td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    <?php else: ?>
      <div class="muted">No active hotspot users.</div>
    <?php endif; ?>
  </div>

  
  <script>
    setInterval(function () {
      if (document.getElementById('bb-active-wrapper')) {
        location.reload();
      }
    }, 30000);
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/blue/resources/views/hotspot/active/index.blade.php ENDPATH**/ ?>