<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{RouterController, PlanController, VoucherController, PaymentController};
use App\Http\Controllers\RouterMetricsController;
use App\Http\Controllers\VpnController;
use App\Http\Controllers\RouterTestController;
use App\Http\Controllers\HotspotProfileController;
use App\Http\Controllers\HotspotVoucherController;
use App\Http\Controllers\HotspotActiveController;

use App\Http\Controllers\HotspotLogController;

use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\OrderController;

use App\Http\Controllers\FreelancerController;

use App\Http\Controllers\AzamCallbackController;


use App\Http\Controllers\FreelancerPortal\FreelancerDashboardController;
use App\Http\Controllers\UserController;

use Illuminate\Http\Request;

Route::post('/azam/callback-debug', function (Request $request) {
    $logFile = storage_path('logs/azam-callback-debug.log');

    file_put_contents(
        $logFile,
        now()->toDateTimeString() . ' RAW CALLBACK: ' . json_encode([
            'ip'      => $request->ip(),
            'headers' => $request->headers->all(),
            'body'    => $request->all(),
        ], JSON_UNESCAPED_UNICODE) . PHP_EOL,
        FILE_APPEND
    );

    return response()->json(['ok' => true]);
})->name('azam.callback.debug');


Route::post('/payments/azam/callback', [AzamCallbackController::class, 'handle'])
    ->name('payments.azam.callback');



Route::get('/payment.php', [PaymentController::class, 'showForm'])
    ->name('payments.form');

Route::post('/payments/order', [PaymentController::class, 'createOrder'])
    ->name('payments.create');

Route::get('/payments/status/{reference}', [PaymentController::class, 'status'])
    ->name('payments.status');


Route::post('/payments/azam/callback', [PaymentController::class, 'azamCallback'])
    ->name('payments.azam.callback');

    
// Ajax poll (JS calls this every few seconds)
Route::post('/payments/check', [PaymentController::class, 'checkStatus'])
    ->name('payments.check');




Route::get('payment.php', [PaymentController::class, 'showForm'])
    ->name('payment.form');

Route::post('payment.php', [PaymentController::class, 'createOrder'])
    ->name('payment.create');

Route::get('payment/result/{reference}', [PaymentController::class, 'showResult'])
    ->name('payment.result');

// AzamPay callback (legacy URL you gave)
Route::post('callback.php', [PaymentController::class, 'azamCallback'])
    ->name('azam.callback');


Route::post('callback.php', [PaymentController::class, 'azamCallback'])
     ->name('azam.callback.legacy');


Route::prefix('pay')->name('pay.')->group(function () {
    // /pay/{router}  e.g. https://bluebando.tekisoft.com/public/pay/1
    Route::get('{router}', [PaymentController::class, 'showForm'])->name('form');
    Route::post('{router}', [PaymentController::class, 'initiate'])->name('initiate');

    Route::get('order/{order}/pending', [PaymentController::class, 'pending'])->name('pending');
    Route::get('order/{order}/success', [PaymentController::class, 'success'])->name('success');
    Route::get('order/{order}/failed',  [PaymentController::class, 'failed'])->name('failed');

    // Webhook for AzamPay
    Route::post('azam/callback', [PaymentController::class, 'azamCallback'])->name('azam.callback');
});


Route::resource('users', UserController::class)->except(['show']);


Route::prefix('freelancer')
    ->name('freelancer.')
    ->middleware(['auth','freelancer'])
    ->group(function () {
        Route::get('/', [FreelancerDashboardController::class, 'index'])
            ->name('dashboard');

        Route::get('/sales', [FreelancerDashboardController::class, 'sales'])
            ->name('sales');

        Route::get('/routers', [FreelancerDashboardController::class, 'routers'])
            ->name('routers');

        Route::get('/profile', [FreelancerDashboardController::class, 'profile'])
            ->name('profile');
    });

Route::resource('freelancers', FreelancerController::class);


// Checkout + payment
Route::get('/checkout', [CheckoutController::class, 'form'])->name('checkout.form');
Route::post('/checkout', [CheckoutController::class, 'create'])->name('checkout.create');

// AzamPay callback URL (configure this in Azam portal)
Route::post('/payments/azampay/callback', [CheckoutController::class, 'azamCallback'])
    ->name('payments.azampay.callback');

// Status pages (simple)
Route::get('/payment/success', fn () => view('payments.status.success'))->name('payments.success');
Route::get('/payment/pending', fn () => view('payments.status.pending'))->name('payments.pending');
Route::get('/payment/failed',  fn () => view('payments.status.failed'))->name('payments.failed');

// Orders list
Route::get('/orders', [OrderController::class, 'index'])->name('payments.orders');
Route::get('/orders/{order}', [OrderController::class, 'show'])->name('orders.show');


// ...

Route::get('hotspot/logs', [HotspotLogController::class, 'index'])
    ->name('hotspot.logs.index');

Route::get('hotspot/user-log', [HotspotLogController::class, 'userLog'])
    ->name('hotspot.userlog.index');


// ...

Route::middleware(['auth'])->group(function () {

    // ... your existing routes (dashboard, routers, plans, etc.)

    Route::prefix('hotspot')->name('hotspot.')->group(function () {
        // Profiles
        Route::get('profiles',        [HotspotProfileController::class, 'index'])->name('profiles.index');
        Route::get('profiles/create', [HotspotProfileController::class, 'create'])->name('profiles.create');
        Route::post('profiles',       [HotspotProfileController::class, 'store'])->name('profiles.store');
        Route::get('profiles/{name}/edit', [HotspotProfileController::class, 'edit'])->name('profiles.edit');
        Route::put('profiles/{name}',      [HotspotProfileController::class, 'update'])->name('profiles.update');
        Route::delete('profiles/{name}',   [HotspotProfileController::class, 'destroy'])->name('profiles.destroy');

        // Vouchers
        Route::get('vouchers',          [HotspotVoucherController::class, 'index'])->name('vouchers.index');
        Route::get('vouchers/create',   [HotspotVoucherController::class, 'create'])->name('vouchers.create');
        Route::post('vouchers',         [HotspotVoucherController::class, 'store'])->name('vouchers.store');
        Route::get('vouchers/bulk',     [HotspotVoucherController::class, 'bulkForm'])->name('vouchers.bulk');
        Route::post('vouchers/bulk',    [HotspotVoucherController::class, 'bulkStore'])->name('vouchers.bulk.store');
        Route::get('vouchers/{id}/edit',[HotspotVoucherController::class, 'edit'])->name('vouchers.edit');
        Route::put('vouchers/{id}',     [HotspotVoucherController::class, 'update'])->name('vouchers.update');
        Route::delete('vouchers/{id}',  [HotspotVoucherController::class, 'destroy'])->name('vouchers.destroy');
        Route::get('vouchers/{id}/print',[HotspotVoucherController::class, 'print'])->name('vouchers.print');

        // Active sessions
       
    Route::get('active', [HotspotActiveController::class, 'index'])->name('active.index');
    Route::post('active/{router}/kick',    [HotspotActiveController::class, 'kick'])->name('active.kick');
    Route::post('active/{router}/disable', [HotspotActiveController::class, 'disable'])->name('active.disable');
    Route::get('active/export', [HotspotActiveController::class, 'export'])->name('active.export');
    Route::post('active/{router}/kick-all',  [HotspotActiveController::class, 'kickAll'])->name('active.kickAll');
    Route::post('active/{router}/kick-mac',  [HotspotActiveController::class, 'kickByMac'])->name('active.kickByMac');
    Route::get('active/history', [HotspotActiveController::class, 'history'])->name('active.history');




        
    });
});

Route::middleware(['auth'])->group(function () {

    // Plans
    Route::resource('plans', PlanController::class);

    // Vouchers (admin/agent)
    Route::get('vouchers', [VoucherController::class, 'index'])->name('vouchers.index');
    Route::get('vouchers/create', [VoucherController::class, 'create'])->name('vouchers.create');
    Route::post('vouchers', [VoucherController::class, 'store'])->name('vouchers.store');

    // Router test connection (we already added earlier)
    Route::post('/routers/test-connection', RouterTestController::class)->name('routers.test');

    // Payments / AzamPay
    Route::get('checkout', [PaymentController::class, 'checkoutForm'])->name('checkout.form');
    Route::post('checkout/azampay', [PaymentController::class, 'startAzamPay'])->name('checkout.azampay.start');
});

// Callback (AzamPay hits this without auth)
Route::post('payments/azampay/callback', [PaymentController::class, 'azampayCallback'])
     ->name('payments.azampay.callback');


Route::post('/routers/test-connection', RouterTestController::class)
     ->name('routers.test')
     ->middleware('auth');


Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');


// routes/web.php
Route::middleware(['auth','role:owner|admin'])->group(function(){
  Route::get('routers/{router}/vpn/create', [VpnController::class,'create'])->name('vpn.create');
  Route::post('routers/{router}/vpn', [VpnController::class,'store'])->name('vpn.store');
    Route::get('vpn/{vpn}/download',  [VpnController::class,'download'])->name('vpn.download');
  Route::post('vpn/{vpn}/revoke', [VpnController::class,'revoke'])->name('vpn.revoke');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});





// routes/web.php (wrap with middleware)
Route::middleware(['auth','role:owner|admin|manager|staff|freelancer'])->group(function(){
    Route::resource('routers', RouterController::class)->except(['show']);
    Route::get('routers/{router}/show', [RouterController::class,'show'])->name('routers.show');
    Route::get('routers/{router}/metrics', [RouterMetricsController::class,'metrics'])->name('routers.metrics');
    Route::get('routers/{router}/interfaces', [RouterMetricsController::class,'interfaces'])->name('routers.interfaces');
    Route::post('routers/{router}/poll', [RouterMetricsController::class,'pollNow'])->name('routers.poll');
});


Route::resource('routers', RouterController::class)->except(['show']);
Route::get('routers/{router}/show', [RouterController::class, 'show'])->name('routers.show');

# live/json endpoints for UI polling
Route::get('routers/{router}/metrics', [RouterMetricsController::class, 'metrics'])->name('routers.metrics');
Route::get('routers/{router}/interfaces', [RouterMetricsController::class, 'interfaces'])->name('routers.interfaces');
Route::post('routers/{router}/poll', [RouterMetricsController::class, 'pollNow'])->name('routers.poll');

require __DIR__.'/auth.php';
