@extends('layouts.app')
@section('title','Vouchers — BlueBando v3')

@section('content')
  <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:12px">
    <div>
      <h1 style="margin:0 0 4px">Vouchers</h1>
      <div class="muted">List of generated vouchers.</div>
    </div>

    <a href="{{ route('vouchers.create') }}" class="btn" style="text-decoration:none">
      + New Voucher
    </a>
  </div>

  <div class="card full">
    @if($vouchers->count())
      <table>
        <thead>
        <tr>
          <th>Code</th>
          <th>Router</th>
          <th>Plan</th>
          <th>Price</th>
          <th>Status</th>
          <th>Buyer</th>
          <th>Created</th>
          <th>By</th>
        </tr>
        </thead>
        <tbody>
        @foreach($vouchers as $v)
          <tr>
            <td><strong>{{ $v->code }}</strong></td>
            <td>{{ $v->router?->name ?? '—' }}</td>
            <td>{{ $v->plan?->name ?? '—' }}</td>
            <td>{{ number_format($v->price) }} {{ $v->currency }}</td>
            <td>
              @php
                $cls = match($v->status){
                    'active' => 'paid',
                    'pending' => 'pending',
                    'used','expired','cancelled' => 'failed',
                    default => ''
                };
              @endphp
              <span class="status {{ $cls }}">{{ ucfirst($v->status) }}</span>
            </td>
            <td>{{ $v->buyer_phone ?: '—' }}</td>
            <td class="muted">{{ $v->created_at->format('Y-m-d H:i') }}</td>
            <td>{{ $v->creator?->name ?? '—' }}</td>
          </tr>
        @endforeach
        </tbody>
      </table>

      <div style="margin-top:10px">
        {{ $vouchers->links() }}
      </div>
    @else
      <div class="muted">No vouchers yet.</div>
    @endif
  </div>
@endsection
