@extends('layouts.app')
@section('title','Add User — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 10px">Add User</h1>

  <div class="card full">
    <form method="POST" action="{{ route('users.store') }}">
      @csrf

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">Name</label>
          <input class="input" name="name" value="{{ old('name') }}" required>
          @error('name')<div class="muted" style="color:var(--bb-red)">{{ $message }}</div>@enderror
        </div>

        <div>
          <label class="label">Email</label>
          <input class="input" type="email" name="email" value="{{ old('email') }}" required>
          @error('email')<div class="muted" style="color:var(--bb-red)">{{ $message }}</div>@enderror
        </div>

        <div>
          <label class="label">Password</label>
          <input class="input" type="password" name="password" required>
          @error('password')<div class="muted" style="color:var(--bb-red)">{{ $message }}</div>@enderror
        </div>

        <div>
          <label class="label">Roles</label>
          <div style="display:flex;flex-wrap:wrap;gap:6px">
            @forelse($roles as $role)
              <label style="font-size:13px">
                <input type="checkbox" name="roles[]" value="{{ $role->name }}"> {{ $role->name }}
              </label>
            @empty
              <div class="muted" style="font-size:12px">No roles yet. You can create them via artisan:</div>
            @endforelse
          </div>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;justify-content:flex-end;gap:8px">
        <a href="{{ route('users.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Save User</button>
      </div>
    </form>
  </div>
@endsection
