@extends('layouts.app')
@section('title','Routers — BlueBando v3')

@section('content')
  <div style="display:flex;gap:10px;justify-content:space-between;align-items:center;margin-bottom:12px">
    <div>
      <h1 style="margin:0 0 6px;font-size:22px">Routers</h1>
      <div class="muted">Manage hotspot routers, poll status and metrics.</div>
    </div>
    <div style="display:flex;gap:8px">
      <form method="get" action="{{ route('routers.index') }}" class="top-search" style="position:relative;min-width:220px">
        <input name="s" value="{{ request('s') }}" placeholder="Search host or name"
               style="width:100%; padding:10px 12px; border-radius:12px; background:var(--bb-elev); color:var(--bb-text); border:1px solid var(--bb-border); outline:none">
      </form>
      <a href="{{ route('routers.create') }}" class="btn" style="text-decoration:none">+ Add Router</a>
    </div>
  </div>

  <div class="card full">
    <table>
      <thead>
        <tr>
          <th>Name</th>
          <th>Host</th>
          <th>Status</th>
          <th>CPU</th>
          <th>RAM</th>
          <th>Uptime</th>
          <th>VPN</th>
          <th>Updated</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        @forelse($routers as $r)
          @php
            // STATUS
            $status = $r->last_status ?: $r->status ?: 'unknown';
            $statusClass = match ($status) {
                'online'  => 'paid',
                'offline' => 'failed',
                'warning' => 'pending',
                default   => 'pending',
            };

            // CPU – prefer last_cpu, fallback to cpu_load
            $cpuText = $r->last_cpu
                ?? ($r->cpu_load !== null ? $r->cpu_load.'%' : null);

            // RAM – from total/free memory
            $memPercent = null;
            if ($r->total_memory && $r->free_memory !== null) {
                $memPercent = round(($r->total_memory - $r->free_memory) / $r->total_memory * 100);
            }

            // Uptime – prefer last_uptime, fallback to uptime_seconds
            if ($r->last_uptime) {
                $uptimeText = $r->last_uptime;
            } elseif ($r->uptime_seconds) {
                $uptimeText = gmdate('j\d H\h i\m s\s', $r->uptime_seconds);
            } else {
                $uptimeText = null;
            }

            // Updated – prefer last_checked_at, then last_seen, then updated_at
            $updatedTs = $r->last_checked_at ?? $r->last_seen ?? $r->updated_at;
          @endphp

          <tr>
            {{-- Name + model --}}
            <td>
              <strong>{{ $r->name }}</strong><br>
              <span class="muted" style="font-size:12px">
                {{ $r->last_model ?? $r->model ?? $r->board_name ?? '—' }}
              </span>
            </td>

            {{-- Host --}}
            <td>{{ $r->host }}</td>

            {{-- Status + latency --}}
            <td>
              <span class="status {{ $statusClass }}">
                {{ strtoupper($status) }}
              </span>
              @if($r->last_latency_ms !== null)
                <div class="muted" style="font-size:12px;margin-top:2px">
                  {{ $r->last_latency_ms }} ms
                </div>
              @endif
            </td>

            {{-- CPU --}}
            <td>{{ $cpuText ?? '—' }}</td>

            {{-- RAM --}}
            <td>
              {{ $memPercent !== null ? $memPercent.'% used' : '—' }}
            </td>

            {{-- Uptime --}}
            <td>
              {{ $uptimeText ?? '—' }}
            </td>

            {{-- VPN --}}
            <td>
              @php
                $vpn = \App\Models\VpnClient::where('router_id', $r->id)->latest()->first();
              @endphp

              @if($vpn && $vpn->status === 'active')
                <span class="status paid">ON</span>
                <div class="muted" style="font-size:12px">{{ $r->vpn_ip ?? '—' }}</div>
                <div style="margin-top:6px">
                  <a class="btn-ghost" href="{{ route('vpn.show', $vpn) }}">View</a>
                </div>
              @else
                <a class="btn-ghost" href="{{ route('vpn.create', $r) }}">Create</a>
              @endif
            </td>

            {{-- Updated --}}
            <td class="muted">
              @if($updatedTs)
                {{ $updatedTs->diffForHumans() }}
              @else
                —
              @endif
            </td>

            {{-- Actions --}}
            <td style="text-align:right">
              <a class="btn-ghost" href="{{ route('routers.show',$r) }}">Open</a>
              <a class="btn-ghost" href="{{ route('routers.edit',$r) }}">Edit</a>
              <form method="POST" action="{{ route('routers.destroy',$r) }}" style="display:inline">
                @csrf
                @method('DELETE')
                <button class="btn-ghost" onclick="return confirm('Delete router?')">Delete</button>
              </form>
            </td>
          </tr>
        @empty
          <tr><td colspan="9" class="muted">No routers yet.</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  <div style="margin-top:10px">{{ $routers->withQueryString()->links() }}</div>
@endsection