@extends('layouts.app')
@section('title','Checkout — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px">
    <h1 style="margin:0 0 6px">Checkout</h1>
    <div class="muted">Sell hotspot vouchers online via AzamPay and auto-log orders.</div>
  </div>

  <div class="card full">
    <form method="POST" action="{{ route('checkout.create') }}" style="display:grid;grid-template-columns:repeat(2,1fr);gap:16px">
      @csrf

      <div>
        <label class="label">Router</label>
        <select name="router_id" class="input" required>
          <option value="">Select router…</option>
          @foreach($routers as $r)
            <option value="{{ $r->id }}" @selected(old('router_id')==$r->id)>{{ $r->name }} ({{ $r->site }})</option>
          @endforeach
        </select>
        @error('router_id')<div class="muted" style="color:var(--bb-red)">{{ $message }}</div>@enderror
      </div>

      <div>
        <label class="label">Plan</label>
        <select name="plan_id" class="input" required>
          <option value="">Select plan…</option>
          @foreach($plans as $p)
            <option value="{{ $p->id }}" @selected(old('plan_id')==$p->id)>
              {{ $p->name }} — {{ number_format($p->price) }} {{ $p->currency ?? 'TZS' }}
            </option>
          @endforeach
        </select>
        @error('plan_id')<div class="muted" style="color:var(--bb-red)">{{ $message }}</div>@enderror
      </div>

      <div>
        <label class="label">Customer Phone (MSISDN)</label>
        <input name="phone" class="input" value="{{ old('phone') }}" placeholder="e.g. 2557XXXXXXX" required>
        @error('phone')<div class="muted" style="color:var(--bb-red)">{{ $message }}</div>@enderror
      </div>

      <div>
        <label class="label">Payment Gateway</label>
        <select name="gateway" class="input" required>
          <option value="azam_pay" @selected(old('gateway')==='azam_pay')>AzamPay</option>
          {{-- Future: Selcom, Flutterwave, etc. --}}
        </select>
      </div>

      <div style="grid-column:1/-1;display:flex;justify-content:flex-end;gap:8px;margin-top:6px">
        <a href="{{ route('payments.orders') }}" class="btn-ghost" style="text-decoration:none">View Orders</a>
        <button class="btn">Start Payment</button>
      </div>
    </form>
  </div>
@endsection
