@extends('layouts.app')
@section('title','Hotspot Vouchers — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:center;gap:12px">
    <div>
      <h1 style="margin:0 0 6px;font-size:22px">Hotspot Vouchers</h1>
      <div class="muted">Latest hotspot users read directly from MikroTik (limited).</div>
    </div>

    <div style="display:flex;gap:8px;align-items:center">
      <form method="GET" action="{{ route('hotspot.vouchers.index') }}" style="display:flex;gap:6px;align-items:center">
        <select name="router_id" class="input" style="min-width:160px">
          @foreach($routers as $r)
            <option value="{{ $r->id }}" @selected(optional($currentRouter)->id === $r->id)>{{ $r->name }}</option>
          @endforeach
        </select>

        <select name="limit" class="input" style="width:90px">
          @foreach([50,100,200,500] as $opt)
            <option value="{{ $opt }}" @selected($limit == $opt)>last {{ $opt }}</option>
          @endforeach
        </select>

        <button class="btn-ghost" type="submit">Load</button>
      </form>

      <a href="{{ route('hotspot.vouchers.bulk', ['router_id'=>optional($currentRouter)->id]) }}" class="btn-ghost" style="text-decoration:none">Generate Bulk</a>
      <a href="{{ route('hotspot.vouchers.create', ['router_id'=>optional($currentRouter)->id]) }}" class="btn" style="text-decoration:none">Add Voucher</a>
    </div>
  </div>

  <div class="card full">
    @if (session('success'))
      <div style="margin-bottom:10px;font-size:13px;padding:8px 10px;border-radius:10px;
                  background:color-mix(in srgb,var(--bb-green) 10%,transparent);
                  border:1px solid color-mix(in srgb,var(--bb-green) 40%,transparent)">
        {{ session('success') }}
      </div>
    @endif
    @if (session('error'))
      <div style="margin-bottom:10px;font-size:13px;padding:8px 10px;border-radius:10px;
                  background:color-mix(in srgb,var(--bb-red) 10%,transparent);
                  border:1px solid color-mix(in srgb,var(--bb-red) 40%,transparent)">
        {{ session('error') }}
      </div>
    @endif

    @if ($offline)
      <div class="muted" style="margin-bottom:8px">Router seems offline or API not reachable.</div>
    @endif

    @php $codes = session('generated_codes', []); @endphp
    @if (!empty($codes))
      <div style="margin-bottom:12px">
        <div style="font-size:13px;margin-bottom:4px">Recently generated codes:</div>
        <div style="display:flex;flex-wrap:wrap;gap:6px">
          @foreach($codes as $c)
            <code style="padding:4px 6px;border-radius:6px;background:var(--bb-elev);border:1px solid var(--bb-border)">{{ $c }}</code>
          @endforeach
        </div>
      </div>
    @endif

    @if (empty($routerUsers))
      <div class="muted">No vouchers found (or none within the selected limit).</div>
    @else
      <table>
        <thead>
        <tr>
          <th>Code</th>
          <th>Profile</th>
          <th>Comment</th>
          <th>Status</th>
          <th>Uptime</th>
          <th>RX</th>
          <th>TX</th>
          <th style="width:150px">Actions</th>
        </tr>
        </thead>
        <tbody>
        @foreach($routerUsers as $u)
          @php
            $disabled = ($u['disabled'] ?? 'false') === 'true';
            $status   = $disabled ? 'Disabled' : 'Enabled';
          @endphp
          <tr>
            <td>{{ $u['name'] ?? '' }}</td>
            <td>{{ $u['profile'] ?? '' }}</td>
            <td>{{ $u['comment'] ?? '' }}</td>
            <td>
              <span class="status {{ $disabled ? 'failed' : 'paid' }}">
                {{ $status }}
              </span>
            </td>
            <td>{{ $u['uptime'] ?? '-' }}</td>
            <td>{{ $u['bytes-in']  ?? '-' }}</td>
            <td>{{ $u['bytes-out'] ?? '-' }}</td>
            <td>
              <a href="{{ route('hotspot.vouchers.print',$u['name'] ?? '') }}" class="muted" target="_blank">Print</a>
               |
              <form method="POST"
                    action="{{ route('hotspot.vouchers.destroy',$u['name'] ?? '') }}?router_id={{ optional($currentRouter)->id }}"
                    style="display:inline"
                    onsubmit="return confirm('Delete voucher {{ $u['name'] ?? '' }} from router?')">
                @csrf @method('DELETE')
                <button type="submit"
                        style="background:none;border:0;color:var(--bb-red);cursor:pointer;font-size:13px">
                  Delete
                </button>
              </form>
            </td>
          </tr>
        @endforeach
        </tbody>
      </table>
    @endif
  </div>
@endsection
