@extends('layouts.app')
@section('title','Create Voucher — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:center">
    <h1 style="margin:0 0 6px;font-size:22px">Create Voucher</h1>
    <a href="{{ route('hotspot.vouchers.index',['router_id'=>optional($currentRouter)->id]) }}" class="btn-ghost" style="text-decoration:none">Back</a>
  </div>

  <div class="card full">
    <form method="POST" action="{{ route('hotspot.vouchers.store') }}">
      @csrf

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">Router</label>
          <select name="router_id" class="input" required>
            @foreach($routers as $r)
              <option value="{{ $r->id }}" @selected(optional($currentRouter)->id === $r->id)>{{ $r->name }}</option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="label">Profile</label>
          <select name="profile" class="input" required>
            <option value="">Select profile…</option>
            @foreach($profiles as $p)
              <option value="{{ $p['name'] ?? '' }}">{{ $p['name'] ?? '' }}</option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="label">Code / Username</label>
          <input type="text" name="code" class="input" required value="{{ old('code') }}">
        </div>

        <div>
          <label class="label">Password (blank = same as code)</label>
          <input type="text" name="password" class="input" value="{{ old('password') }}">
        </div>

        <div style="grid-column:1/-1">
          <label class="label">Comment (optional)</label>
          <input type="text" name="comment" class="input" value="{{ old('comment') }}">
        </div>
      </div>

      <div style="margin-top:16px;display:flex;justify-content:flex-end;gap:8px">
        <a href="{{ route('hotspot.vouchers.index',['router_id'=>optional($currentRouter)->id]) }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn" type="submit">Create</button>
      </div>
    </form>
  </div>
@endsection
