@extends('layouts.app')
@section('title','Hotspot Profiles — BlueBando v3')

@section('content')
  <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:14px;gap:12px;flex-wrap:wrap">
    <div>
      <h1 style="margin:0 0 4px">Hotspot Profiles</h1>
      <div class="muted">All <code>/ip hotspot user profile</code> on your MikroTik routers.</div>
    </div>

    <div style="display:flex;gap:8px;align-items:center;flex-wrap:wrap">
      <form method="get" action="{{ route('hotspot.profiles.index') }}">
        <select class="input" name="router_id" onchange="this.form.submit()">
          @foreach($routers as $r)
            <option value="{{ $r->id }}" @selected($routerId == $r->id)>{{ $r->name }}</option>
          @endforeach
        </select>
      </form>

      @if($router)
        <a href="{{ route('hotspot.profiles.create',['router_id'=>$router->id]) }}"
           class="btn" style="text-decoration:none">+ New Profile</a>
      @endif
    </div>
  </div>

  @if(session('status'))
    <div class="card full" style="margin-bottom:12px;border-left:3px solid var(--bb-green)">
      {{ session('status') }}
    </div>
  @endif

  <div class="card full">
    @if($router && !empty($profiles))
      <table>
        <thead>
          <tr>
            <th>Name</th>
            <th>Rate limit</th>
            <th>Shared users</th>
            <th>Idle timeout</th>
            <th>Keepalive</th>
            <th>Parent queue</th>
            <th>Comment</th>
            <th style="width:120px;text-align:right">Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($profiles as $p)
            <tr>
              <td>{{ $p['name'] }}</td>
              <td>{{ $p['rate_limit'] ?? '—' }}</td>
              <td>{{ $p['shared_users'] ?? '—' }}</td>
              <td>{{ $p['idle_timeout'] ?? '—' }}</td>
              <td>{{ $p['keepalive_timeout'] ?? '—' }}</td>
              <td>{{ $p['parent_queue'] ?? '—' }}</td>
              <td class="muted">{{ $p['comment'] ?? '—' }}</td>
              <td style="text-align:right">
                <a href="{{ route('hotspot.profiles.edit',[$router->id,$p['name']]) }}"
                   class="btn-ghost" style="padding:4px 8px;font-size:12px">Edit</a>
                <form method="POST"
                      action="{{ route('hotspot.profiles.destroy',[$router->id,$p['name']]) }}"
                      style="display:inline"
                      onsubmit="return confirm('Delete this profile from MikroTik?')">
                  @csrf @method('DELETE')
                  <button class="btn-ghost" style="padding:4px 8px;font-size:12px;color:#ef4444">
                    Delete
                  </button>
                </form>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>
    @else
      <div class="muted">No profiles found or router not reachable.</div>
    @endif
  </div>
@endsection
