@extends('layouts.app')
@section('title','Edit Hotspot Profile — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 12px">Edit Hotspot Profile</h1>

  <div class="card full">
    <form method="POST" action="{{ route('hotspot.profiles.update',[$router->id,$profile['name']]) }}">
      @csrf
      @method('PUT')

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">Router</label>
          <input class="input" value="{{ $router->name }}" disabled>
        </div>

        <div>
          <label class="label">Name</label>
          <input class="input" name="name" required value="{{ $profile['name'] }}">
        </div>

        <div>
          <label class="label">Rate limit</label>
          <input class="input" name="rate_limit" value="{{ $profile['rate_limit'] }}">
        </div>

        <div>
          <label class="label">Shared users</label>
          <input class="input" name="shared_users" value="{{ $profile['shared_users'] }}">
        </div>

        <div>
          <label class="label">Idle timeout</label>
          <input class="input" name="idle_timeout" value="{{ $profile['idle_timeout'] }}">
        </div>

        <div>
          <label class="label">Keepalive timeout</label>
          <input class="input" name="keepalive_timeout" value="{{ $profile['keepalive_timeout'] }}">
        </div>

        <div>
          <label class="label">Parent queue</label>
          <input class="input" name="parent_queue" value="{{ $profile['parent_queue'] }}">
        </div>

        <div>
          <label class="label">Comment</label>
          <input class="input" name="comment" value="{{ $profile['comment'] }}">
        </div>
      </div>

      <div style="margin-top:14px;display:flex;justify-content:flex-end;gap:8px">
        <a href="{{ route('hotspot.profiles.index',['router_id'=>$router->id]) }}"
           class="btn-ghost" style="text-decoration:none">
          Cancel
        </a>
        <button class="btn">Update Profile</button>
      </div>
    </form>
  </div>
@endsection
