@extends('layouts.app')
@section('title','Active Hotspot Users — BlueBando v3')

@section('content')
  @php
    // formatter
    function bb_format_bytes($bytes) {
        $bytes = (float)$bytes;
        if ($bytes < 1024) return $bytes.' B';
        if ($bytes < 1048576) return round($bytes/1024,2).' KB';
        if ($bytes < 1073741824) return round($bytes/1048576,2).' MB';
        if ($bytes < 1099511627776) return round($bytes/1073741824,2).' GB';
        return round($bytes/1099511627776,2).' TB';
    }

    $count = is_array($sessions) ? count($sessions) : 0;

    // compute max traffic for bar + chart
    $maxTraffic = 0;
    foreach ($sessions as $tmp) {
        $t = (int)($tmp['_traffic'] ?? 0);
        if ($t > $maxTraffic) $maxTraffic = $t;
    }
    $maxTraffic = $maxTraffic ?: 1;

    $routerId = optional($currentRouter)->id;
  @endphp

  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:center;gap:12px">
    <div>
      <h1 style="margin:0 0 4px;font-size:22px;letter-spacing:.2px;display:flex;align-items:center;gap:8px">
        <x-ico name="wifi" :size="22" />
        <span>Hotspot Active</span>
      </h1>
      <div class="muted" style="font-size:13px">
        Live hotspot sessions for <strong>{{ $currentRouter?->name ?? '—' }}</strong>
      </div>
    </div>

    <form method="GET" action="{{ route('hotspot.active.index') }}"
          style="display:flex;gap:8px;align-items:center;flex-wrap:wrap;justify-content:flex-end">

      <select name="router_id" class="input" style="min-width:180px">
        @foreach($routers as $r)
          <option value="{{ $r->id }}" @selected($routerId === $r->id)>
            {{ $r->name }}
          </option>
        @endforeach
      </select>

      <select name="limit" class="input" style="width:110px">
        @foreach([50,100,200,500] as $opt)
          <option value="{{ $opt }}" @selected($limit == $opt)>Last {{ $opt }}</option>
        @endforeach
      </select>

      <select name="sort" class="input" style="width:130px">
        <option value="traffic"   @selected($sort === 'traffic')>Traffic</option>
        <option value="bytes_in"  @selected($sort === 'bytes_in')>Bytes In</option>
        <option value="bytes_out" @selected($sort === 'bytes_out')>Bytes Out</option>
        <option value="uptime"    @selected($sort === 'uptime')>Uptime</option>
        <option value="user"      @selected($sort === 'user')>User</option>
      </select>

      <select name="dir" class="input" style="width:90px">
        <option value="desc" @selected($dir === 'desc')>Desc</option>
        <option value="asc"  @selected($dir === 'asc')>Asc</option>
      </select>

      <button class="btn-ghost" type="submit">Apply</button>

      <a href="{{ route('hotspot.active.export', ['router_id' => $routerId, 'limit' => $limit, 'sort' => $sort, 'dir' => $dir]) }}"
         class="btn-ghost" style="text-decoration:none">
        Export CSV
      </a>
    </form>
  </div>

  <div class="card full" id="bb-active-wrapper">

    <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:10px;gap:10px">
      <div style="display:flex;align-items:center;gap:8px">
        <div style="width:26px;height:26px;border-radius:999px;display:grid;place-items:center;
                    background:var(--bb-elev);border:1px solid var(--bb-border);">
          <x-ico name="wifi" :size="16" />
        </div>
        <div>
          <div style="font-weight:600">
            Hotspot Active
            <span style="font-size:12px;font-weight:400" class="muted">
              • {{ $count }} active {{ \Illuminate\Support\Str::plural('session',$count) }}
              • sorted by {{ strtoupper($sort) }}
            </span>
          </div>
          <div class="muted" style="font-size:11px">
            Auto refresh every <b>30 seconds</b>.
          </div>
        </div>
      </div>

      <div style="display:flex;align-items:center;gap:10px;font-size:12px">
        <form method="POST"
              action="{{ route('hotspot.active.kickAll', $currentRouter) }}"
              onsubmit="return confirm('Disconnect ALL active users on this router?')">
          @csrf
          <button type="submit"
                  style="border:0;padding:6px 10px;border-radius:999px;font-size:11px;
                         background:color-mix(in srgb,var(--bb-red) 12%,transparent);
                         border:1px solid color-mix(in srgb,var(--bb-red) 45%,transparent);
                         color:color-mix(in srgb,var(--bb-red) 90%,white);cursor:pointer;">
            Kick All
          </button>
        </form>

        <div class="muted">
          Last refresh: <span style="color:var(--bb-text)">{{ now()->format('Y-m-d H:i:s') }}</span>
        </div>
      </div>
    </div>

    {{-- SIMPLE TOP TALKERS CHART --}}
    @if($count > 0)
      @php
        $topTalkers = collect($sessions)
          ->sortByDesc('_traffic')
          ->take(8)
          ->map(function($s){
            return [
              'user' => $s['user'] ?? $s['name'] ?? '-',
              'traffic' => (int)($s['_traffic'] ?? 0),
            ];
          })->values()->all();

        $chartMax = 0;
        foreach ($topTalkers as $tt) {
          if ($tt['traffic'] > $chartMax) $chartMax = $tt['traffic'];
        }
        $chartMax = $chartMax ?: 1;
      @endphp

      <div style="margin-bottom:12px">
        <div class="muted" style="font-size:11px;margin-bottom:4px">Top talkers (Bytes In + Out)</div>
        <div style="display:flex;gap:8px;align-items:flex-end;min-height:80px">
          @foreach($topTalkers as $tt)
            @php
              $h = max(8, ($tt['traffic'] / $chartMax) * 70);
            @endphp
            <div style="flex:1;display:flex;flex-direction:column;align-items:center;gap:4px">
              <div style="width:100%;border-radius:999px 999px 4px 4px;
                          background:linear-gradient(180deg,var(--bb-primary-2),var(--bb-primary-1));
                          height:{{ $h }}px"></div>
              <div style="font-size:10px;text-align:center;max-width:80px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap">
                {{ $tt['user'] }}
              </div>
            </div>
          @endforeach
        </div>
      </div>
    @endif

    @if ($count > 0)
      <div style="overflow-x:auto">
        <table>
          <thead>
          <tr>
            <th>Server</th>
            <th>User</th>
            <th>Address</th>
            <th>MAC Address</th>
            <th>Uptime</th>
            <th>Bytes In</th>
            <th>Bytes Out</th>
            <th>Traffic</th>
            <th>Time Left</th>
            <th>Login By</th>
            <th style="min-width:150px">Actions</th>
            <th>Comment</th>
          </tr>
          </thead>
          <tbody>
          @foreach($sessions as $s)
            @php
              $server    = $s['server'] ?? $s['server-name'] ?? 'hotspot1';
              $user      = $s['user'] ?? $s['name'] ?? '';
              $address   = $s['address'] ?? '';
               $mac       = $s['mac-address']    ?? $s['mac'] ?? '';
              $uptime    = $s['uptime'] ?? '-';
              $bytesIn   = (int)($s['_bytes_in'] ?? 0);
              $bytesOut  = (int)($s['_bytes_out'] ?? 0);
              $trafficBytes = (int)($s['_traffic'] ?? 0);
              $trafficPct   = min(100, ($trafficBytes / $maxTraffic) * 100);
              $timeLeft  = $s['session-time-left'] ?? $s['time_left'] ?? '-';
              $loginBy   = $s['login-by'] ?? '';
              $comment   = $s['comment'] ?? '';
              $id        = $s['.id'] ?? $s['id'] ?? null;
            @endphp

            <tr>
              <td>{{ $server }}</td>
              <td style="font-weight:500">{{ $user }}</td>
              <td>{{ $address }}</td>
              <td class="muted">{{ $mac }}</td>
              <td>{{ $uptime }}</td>

              <td>{{ bb_format_bytes($bytesIn) }}</td>
              <td>{{ bb_format_bytes($bytesOut) }}</td>

              <td>
                <div style="font-size:11px;margin-bottom:2px">
                  {{ bb_format_bytes($trafficBytes) }}
                </div>
                <div style="height:6px;border-radius:999px;background:var(--bb-elev);overflow:hidden;
                            border:1px solid var(--bb-border);">
                  <div style="height:100%;width:{{ $trafficPct }}%;
                              background:linear-gradient(90deg,var(--bb-primary-1),var(--bb-primary-2));">
                  </div>
                </div>
              </td>

              <td>{{ $timeLeft }}</td>

              <td>
                @if($loginBy)
                  <span style="padding:4px 8px;border-radius:999px;font-size:11px;
                               border:1px solid var(--bb-border);background:var(--bb-elev);">
                    {{ $loginBy }}
                  </span>
                @endif
              </td>

              <td>
                <div style="display:flex;gap:6px;flex-wrap:wrap">
                  {{-- Kick --}}
                  @if($id)
                    <form method="POST"
                          action="{{ route('hotspot.active.kick', $currentRouter) }}"
                          onsubmit="return confirm('Disconnect this session?')">
                      @csrf
                      <input type="hidden" name="id" value="{{ $id }}">
                      <button type="submit"
                              style="border:0;padding:4px 8px;border-radius:999px;font-size:11px;
                                     background:color-mix(in srgb,var(--bb-yellow) 12%,transparent);
                                     border:1px solid color-mix(in srgb,var(--bb-yellow) 45%,transparent);
                                     color:color-mix(in srgb,var(--bb-yellow) 90%,white);cursor:pointer;">
                        Kick
                      </button>
                    </form>
                  @endif

                  {{-- Kick by MAC --}}
                  @if($mac)
                    <form method="POST"
                          action="{{ route('hotspot.active.kickByMac', $currentRouter) }}"
                          onsubmit="return confirm('Disconnect ALL sessions using MAC {{ $mac }}?')">
                      @csrf
                      <input type="hidden" name="mac" value="{{ $mac }}">
                      <button type="submit"
                              style="border:0;padding:4px 8px;border-radius:999px;font-size:11px;
                                     background:var(--bb-elev);
                                     border:1px solid var(--bb-border);
                                     color:var(--bb-text);cursor:pointer;">
                        Kick MAC
                      </button>
                    </form>
                  @endif

                  {{-- Disable user --}}
                  @if($user)
                    <form method="POST"
                          action="{{ route('hotspot.active.disable', $currentRouter) }}"
                          onsubmit="return confirm('Disable hotspot user {{ $user }}?')">
                      @csrf
                      <input type="hidden" name="user" value="{{ $user }}">
                      <button type="submit"
                              style="border:0;padding:4px 8px;border-radius:999px;font-size:11px;
                                     background:color-mix(in srgb,var(--bb-red) 12%,transparent);
                                     border:1px solid color-mix(in srgb,var(--bb-red) 45%,transparent);
                                     color:color-mix(in srgb,var(--bb-red) 90%,white);cursor:pointer;">
                        Disable
                      </button>
                    </form>
                  @endif
                </div>
              </td>

              <td class="muted" style="font-size:12px">{{ $comment }}</td>
            </tr>
          @endforeach
          </tbody>
        </table>
      </div>
    @else
      <div class="muted">No active hotspot users.</div>
    @endif
  </div>

  {{-- AUTO REFRESH EVERY 30 SECONDS --}}
  <script>
    setInterval(function () {
      if (document.getElementById('bb-active-wrapper')) {
        location.reload();
      }
    }, 30000);
  </script>
@endsection