<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}">
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>BlueBando v3 — Create account</title>
  <style>
    :root{--bb-bg:#0d1117;--bb-panel:#111827;--bb-blue:#0ea5e9;--bb-blue-2:#3b82f6;--bb-text:#e5e7eb;--bb-dim:#9ca3af;--radius:18px;--sh:0 20px 60px rgba(0,0,0,.45)}
    *{box-sizing:border-box} html,body{height:100%}
    body{margin:0;color:var(--bb-text);background:radial-gradient(1200px 700px at 80% -10%, #0b3a6b44, transparent 60%),
      radial-gradient(1200px 700px at -10% 110%, #064e3b33, transparent 60%),linear-gradient(180deg,#0b1020,#0d1117);
      font:14px/1.45 ui-sans-serif,system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial;display:grid;place-items:center;padding:24px}
    .card{width:min(100%,720px);background:linear-gradient(180deg,rgba(255,255,255,.02),transparent),var(--bb-panel);
      border:1px solid rgba(148,163,184,.12);border-radius:var(--radius);box-shadow:var(--sh);padding:26px}
    .title{display:flex;gap:12px;align-items:center;margin-bottom:14px}
    .dot{width:10px;height:10px;border-radius:999px;background:linear-gradient(135deg,#22d3ee,#3b82f6);box-shadow:0 0 0 4px #22d3ee33}
    label{display:block;font-size:12px;color:var(--bb-dim);margin:14px 2px 6px}
    .row{display:grid;grid-template-columns:1fr 1fr;gap:12px} @media(max-width:720px){.row{grid-template-columns:1fr}}
    .input{width:100%;padding:14px;border-radius:14px;background:linear-gradient(180deg,#0d1525,#0b1220);color:var(--bb-text);
      border:1px solid rgba(148,163,184,.18);outline:none;transition:.25s;border-color:.25s,box-shadow}
    .input:focus{border-color:#38bdf8;box-shadow:0 0 0 4px #38bdf822}
    .btn{width:100%;padding:14px;border-radius:14px;border:0;cursor:pointer;color:white;background:linear-gradient(135deg,var(--bb-blue-2),var(--bb-blue));
      box-shadow:0 10px 30px #0ea5e955,inset 0 0 0 1px rgba(255,255,255,.12);font-weight:700;letter-spacing:.3px}
    .muted{color:var(--bb-dim)} .error{background:#ef44441a;border:1px solid #ef44444d;color:#fecaca;padding:10px 12px;border-radius:12px;margin-top:10px}
    .link{color:#93c5fd;text-decoration:none} .link:hover{text-decoration:underline}
  </style>
</head>
<body>
  <section class="card">
    <div class="title">
      <span class="dot"></span>
      <div><div style="font-weight:800;letter-spacing:.3px;">Create your BlueBando account</div>
        <div class="muted" style="font-size:12px">Join to manage routers, vouchers, payments & SMS</div></div>
    </div>

    @if ($errors->any()) <div class="error">{{ $errors->first() }}</div> @endif

    <form method="POST" action="{{ route('register') }}" novalidate>
      @csrf
      <div class="row">
        <div>
          <label for="name">Full name</label>
          <input id="name" name="name" class="input" placeholder="Evans Zirariye" value="{{ old('name') }}" required>
        </div>
        <div>
          <label for="email">Email</label>
          <input id="email" type="email" name="email" class="input" placeholder="owner@blue.local" value="{{ old('email') }}" required>
        </div>
      </div>

      <div class="row">
        <div>
          <label for="password">Password</label>
          <input id="password" type="password" name="password" class="input" placeholder="••••••••" required>
        </div>
        <div>
          <label for="password_confirmation">Confirm Password</label>
          <input id="password_confirmation" type="password" name="password_confirmation" class="input" placeholder="••••••••" required>
        </div>
      </div>

      <div style="margin-top:16px"><button class="btn" type="submit">Create account</button></div>
    </form>

    <p class="muted" style="text-align:center;margin-top:14px">
      Already have an account? <a class="link" href="{{ route('login') }}">Sign in</a>
    </p>
  </section>
</body>
</html>