<?php
namespace App\Services\Sms;

use Illuminate\Support\Facades\Http;

class NextSmsGateway implements SmsGateway
{
    public function send(string $to, string $message, array $meta=[]): SmsResult
    {
        $resp = Http::withHeaders(['Authorization'=>'Bearer '.env('SMS_NEXTSMS_KEY')])
            ->asJson()->post('https://messaging.nextsms.co.tz/api/sendsms/', [
                'to'=>$to,'message'=>$message,'from'=>$meta['from'] ?? 'TEKISOFT'
            ]);
        return new SmsResult($resp->successful(), $resp->json());
    }
}
