<?php

namespace App\Services\Router;

use App\Models\Router;
use Exception;

class MikroTikClient
{
    protected \RouterOS\Client $client;

    public static function for(Router $router): self
    {
        $config = [
            'host' => $router->host,
            'user' => $router->username,
            'pass' => $router->password,
            'port' => $router->api_port ?: 8728,
            'timeout' => 3,
            'ssl' => $router->use_tls,
        ];

        $self = new self();
        $self->client = new \RouterOS\Client($config);
        return $self;
    }

    public function getIdentity(): array
    {
        $response = (new \RouterOS\Query('/system/identity/print'));
        $r = $this->client->query($response)->read();
        return $r[0] ?? [];
    }

    public function getResources(): array
    {
        $q = new \RouterOS\Query('/system/resource/print');
        $r = $this->client->query($q)->read();
        return $r[0] ?? [];
    }

    public function getBoardInfo(): array
    {
        $q = new \RouterOS\Query('/system/routerboard/print');
        $r = $this->client->query($q)->read();
        return $r[0] ?? [];
    }

    public function getInterfaces(): array
    {
        $q = new \RouterOS\Query('/interface/print');
        return $this->client->query($q)->read();
    }

    public function getInterfaceTraffic(string $name): array
    {
        // Two samples to compute bps
        $q = new \RouterOS\Query('/interface/monitor-traffic');
        $q->equals('interface', $name)->equals('once', '')->equal('once', true);
        return $this->client->query($q)->read()[0] ?? [];
    }
}
