<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Router extends Model
{
  // add to $fillable
protected $fillable = [
  'name','vendor','model','board_name','serial',
  'host','wan_host','ddns_host','vpn_ip','prefer_vpn','connection_via',
  'api_port','username','password','password_enc','use_tls',
  'site','tags','status','last_seen',
  'cpu_load','free_memory','total_memory','free_hdd','total_hdd','uptime_seconds','company_id','last_status',
        'last_latency_ms',
        'last_identity',
        'last_model',
        'last_cpu',
        'last_uptime',
        'last_checked_at'
];



    protected $casts = [
        'tags'      => 'array',
        'use_tls'   => 'boolean',
        'last_seen' => 'datetime',
        'tls'            => 'boolean',
        'prefer_vpn'     => 'boolean',
        'last_checked_at'=> 'datetime',
        
    ];

    public function stats() { return $this->hasMany(RouterStat::class); }
    public function interfaces() { return $this->hasMany(RouterInterface::class); }

    public function online(): bool { return $this->status === 'online'; }
}
