<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\Payments\{GatewayFactory, AzamPaySignature};

class WebhookController extends Controller
{
    public function payment(string $provider, Request $r, GatewayFactory $factory)
    {
        if ($provider === 'azam_pay') {
            $headerName = env('PAYMENT_AZAM_WEBHOOK_HEADER', 'X-AZAM-SIGNATURE');
            $sig = $r->header($headerName);
            $raw = $r->getContent();
            if (!AzamPaySignature::verify($sig, $raw)) {
                return response()->json(['ok'=>false,'error'=>'invalid signature'], 401);
            }
        }
        $gw = $factory->for($provider);
        $gw->handleWebhook($r->all());
        return response()->json(['ok'=>true]);
    }
}
