<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class RouterMetricsController extends Controller
{
    // Show main router metrics page (you can improve later)
    public function metrics($routerId)
    {
        // For now, just return a simple JSON to avoid errors
        return response()->json([
            'router_id' => $routerId,
            'message'   => 'Router metrics endpoint (stub) is working.',
        ]);
    }

    // Return interfaces data (stub)
    public function interfaces($routerId)
    {
        return response()->json([
            'router_id' => $routerId,
            'interfaces' => [],
        ]);
    }

    // Manual polling (stub)
    public function pollNow($routerId, Request $request)
    {
        return response()->json([
            'router_id' => $routerId,
            'polled'    => true,
        ]);
    }
}